/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auditlog.access_log.read;

import com.floragunn.searchguard.enterprise.auditlog.access_log.read.FieldReadCallback;
import com.floragunn.searchguard.enterprise.auditlog.access_log.read.ReadLogContext;
import com.floragunn.searchsupport.dfm.MaskedFieldsConsumer;
import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;

public class ComplianceAwareStoredFieldVisitor
extends StoredFieldVisitor
implements MaskedFieldsConsumer {
    private final StoredFieldVisitor delegate;
    private FieldReadCallback fieldReadCallback;

    public ComplianceAwareStoredFieldVisitor(StoredFieldVisitor delegate, ReadLogContext context) {
        this.delegate = delegate;
        this.fieldReadCallback = new FieldReadCallback(context);
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
        this.fieldReadCallback.binaryFieldRead(fieldInfo, value, f -> false);
        this.delegate.binaryField(fieldInfo, value);
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        return this.delegate.needsField(fieldInfo);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
        this.fieldReadCallback.stringFieldRead(fieldInfo, value, f -> false);
        this.delegate.stringField(fieldInfo, value);
    }

    public void intField(FieldInfo fieldInfo, int value) throws IOException {
        this.fieldReadCallback.numericFieldRead(fieldInfo, value);
        this.delegate.intField(fieldInfo, value);
    }

    public void longField(FieldInfo fieldInfo, long value) throws IOException {
        this.fieldReadCallback.numericFieldRead(fieldInfo, value);
        this.delegate.longField(fieldInfo, value);
    }

    public void floatField(FieldInfo fieldInfo, float value) throws IOException {
        this.fieldReadCallback.numericFieldRead(fieldInfo, Float.valueOf(value));
        this.delegate.floatField(fieldInfo, value);
    }

    public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
        this.fieldReadCallback.numericFieldRead(fieldInfo, value);
        this.delegate.doubleField(fieldInfo, value);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void finished() {
        this.fieldReadCallback.finished();
        this.fieldReadCallback = null;
    }

    public void binaryMaskedField(FieldInfo fieldInfo, byte[] value, Function<String, Boolean> masked) throws IOException {
        this.fieldReadCallback.binaryFieldRead(fieldInfo, value, masked);
        this.delegate.binaryField(fieldInfo, value);
    }

    public void stringMaskedField(FieldInfo fieldInfo, byte[] value) throws IOException {
        this.fieldReadCallback.stringFieldRead(fieldInfo, value, f -> true);
        this.delegate.stringField(fieldInfo, value);
    }
}

